/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.updates;

import com.ibm.hwmca.base.updates.MCF;
import com.ibm.hwmca.base.updates.McfKeyword;
import com.ibm.hwmca.base.updates.McfKeywordEvent;
import com.ibm.hwmca.base.updates.McfKeywordListener;
import com.ibm.hwmca.base.updates.UpdatesErrorIds;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.util.Trace;
import java.util.ArrayList;
import java.util.Iterator;

public final class McfKeywordListenerManager
implements UpdatesErrorIds {
    private static final String TRACE_MASKT = "XMCFKLMT";
    private static final String TRACE_MASKF = "XMCFKLMF";
    private static final String TRACE_MASKD = "XMCFKLMD";
    private static final String TRACE_CLASS = "McfKeywordListenerManager";
    private static final String TRACE_IN = "-> ";
    private static final String TRACE_OUT = "<- ";
    private static final String TRACE_INOUT = "<> ";
    private static final String TRACE_OTHER = "   ";
    private static final int DISCOVERY = 1;
    private static final int EVENT = 2;
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(2, "McfKeyLstMgr");
    private static McfKeywordListenerManager theMcfKeywordListenerManager = null;
    private ArrayList listeners = new ArrayList();
    private Object listenersLock = new Object();

    public static synchronized McfKeywordListenerManager getMcfKeywordListenerManager() {
        String TRACE_METHOD = ".getMcfKeywordListenerManager()";
        Trace.trace(TRACE_MASKT, "-> McfKeywordListenerManager" + TRACE_METHOD);
        if (theMcfKeywordListenerManager == null) {
            theMcfKeywordListenerManager = new McfKeywordListenerManager();
        }
        Trace.trace(TRACE_MASKT, "<- McfKeywordListenerManager" + TRACE_METHOD);
        return theMcfKeywordListenerManager;
    }

    private McfKeywordListenerManager() {
        String TRACE_METHOD = ".ctor()";
        Trace.trace(TRACE_MASKT, "<> McfKeywordListenerManager" + TRACE_METHOD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(McfKeywordListener listener) {
        String TRACE_METHOD = ".addListener()";
        Trace.trace(TRACE_MASKT, "-> McfKeywordListenerManager" + TRACE_METHOD);
        Object object = this.listenersLock;
        synchronized (object) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
        Trace.trace(TRACE_MASKT, "<- McfKeywordListenerManager" + TRACE_METHOD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(McfKeywordListener listener) {
        String TRACE_METHOD = ".removeListener()";
        Trace.trace(TRACE_MASKT, "-> McfKeywordListenerManager" + TRACE_METHOD);
        Object object = this.listenersLock;
        synchronized (object) {
            this.listeners.remove(listener);
        }
        Trace.trace(TRACE_MASKT, "<- McfKeywordListenerManager" + TRACE_METHOD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendEvent(int type, McfKeyword keyword, MCF mcf, McfKeywordEvent event) {
        ArrayList listeners;
        String TRACE_METHOD = ".sendEvent()";
        Trace.trace(TRACE_MASKT, "-> McfKeywordListenerManager" + TRACE_METHOD);
        Object object = this.listenersLock;
        synchronized (object) {
            listeners = (ArrayList)this.listeners.clone();
        }
        Iterator iterator = listeners.iterator();
        while (iterator.hasNext()) {
            McfKeywordListener l = (McfKeywordListener)iterator.next();
            Trace.trace(TRACE_MASKF, "   McfKeywordListenerManager" + TRACE_METHOD + " - keyword listener is " + l);
            switch (type) {
                case 1: {
                    l.keywordDiscovered(keyword, mcf);
                    break;
                }
                case 2: {
                    l.keywordEvent(event);
                }
            }
        }
        Trace.trace(TRACE_MASKT, "<- McfKeywordListenerManager" + TRACE_METHOD);
    }

    public void keywordDiscovered(McfKeyword keyword, MCF mcf) {
        String TRACE_METHOD = ".keywordDiscovered()";
        Trace.trace(TRACE_MASKT, "-> McfKeywordListenerManager" + TRACE_METHOD);
        this.sendEvent(1, keyword, mcf, null);
        Trace.trace(TRACE_MASKT, "<- McfKeywordListenerManager" + TRACE_METHOD);
    }

    public void keywordEvent(McfKeywordEvent event) {
        String TRACE_METHOD = ".keywordEvent()";
        Trace.trace(TRACE_MASKT, "-> McfKeywordListenerManager" + TRACE_METHOD);
        this.sendEvent(2, null, null, event);
        Trace.trace(TRACE_MASKT, "<- McfKeywordListenerManager" + TRACE_METHOD);
    }
}

